<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\String\StringHelper;
use Joomla\CMS\MVC\Model\AdminModel;

class SpbookingModelTransport extends AdminModel
{
	protected $text_prefix = 'COM_SPBOOKING';

	public function getTable($name = 'Transport', $prefix = 'SpbookingTable', $config = array())
	{
		return Table::getInstance($name, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		$app = Factory::getApplication();
		$form = $this->loadForm('com_spbooking.transport', 'transport', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	public function loadFormData()
	{
		$data = Factory::getApplication()
			->getUserState('com_spbooking.edit.transport.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}

	protected function canDelete($record)
	{
		if (!empty($record->id))
		{
			if ($record->published != -2)
			{
				return;
			}

			$user = Factory::getUser();

			return parent::canDelete($record);
		}
	}

	protected function canEditState($record)
	{
		return parent::canEditState($record);
	}

	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk))
		{
			if (!empty($item->transport_tags) && is_string($item->transport_tags))
			{
				$item->transport_tags = json_decode($item->transport_tags);
			}

			if (!empty($item->place_ids) && is_string($item->place_ids))
			{
				$item->place_ids = json_decode($item->place_ids);
			}

			if (!empty($item->certificates) && is_string($item->certificates))
			{
				$item->certificates = json_decode($item->certificates);
			}

			if (!empty($item->features) && is_string($item->features))
			{
				$item->features = json_decode($item->features);
			}

			if (!empty($item->facilities) && is_string($item->facilities))
			{
				$item->facilities = json_decode($item->facilities);
			}

			if (!empty($item->additional_reviews) && is_string($item->additional_reviews))
			{
				$item->additional_reviews = json_decode($item->additional_reviews);
			}

			if (!empty($item->gallery) && is_string($item->gallery))
			{
				$item->gallery = json_decode($item->gallery, true);
			}

			return $item;
		}

		return parent::getItem($pk);
	}

	private function generateNewTitleLocally($alias, $title)
	{
		// Alter the title & alias
		$table = $this->getTable();

		while ($table->load(array('alias' => $alias)))
		{
			$title = StringHelper::increment($title);
			$alias = StringHelper::increment($alias, 'dash');
		}

		return array($title, $alias);
	}

	public function save($data)
	{
		$input 	= Factory::getApplication()->input;
		$task 	= $input->get('task');

		if ($task == 'save2copy')
		{
			$originalTable = clone $this->getTable();
			$originalTable->load($input->getInt('id'));

			if ($data['title'] == $originalTable->title)
			{
				list($title, $alias) = $this->generateNewTitleLocally($data['alias'], $data['title']);
				$data['title'] = $title;
				$data['alias'] = $alias;
			}
			else
			{
				if ($data['alias'] == $originalTable->alias)
				{
					$data['alias'] = '';
				}
			}

			$data['published'] = 0;
		}

		if (parent::save($data))
		{
			return true;
		}

		return false;
	}
}

