<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\MVC\Model\ListModel;

class SpbookingModelRooms extends ListModel {
	public function __construct(array $config = array()) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = [
				'id','a.id',
				'title', 'a.title',
				'adult', 'a.adult',
				'child', 'a.child',
				'accomodation_id', 'a.accomodation_id',
				'room_number', 'a.room_number',
				'created_by', 'a.created_by',
				'created', 'a.created',
				'published', 'a.published',
				'room_tags', 'a.room_tags',
				'featured', 'a.featured',
				'access', 'a.access',
				'language', 'a.language'
			];
		}
		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.ordering', $direction = 'asc') {
		$app = Factory::getApplication();
		$context = $this->context;

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$language = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '') {
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.language');

		return parent::getStoreId($id);
	}

	protected function getListQuery() {
		$app 	= Factory::getApplication();
		$state = $this->get('State');
		$db 	= Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.*, l.title_native as lang, ac.title as accomodation_title');
		$query->from($db->quoteName('#__spbooking_rooms', 'a'));
		$query->join('LEFT' , $db->quoteName('#__languages', 'l') . ' ON (' . $db->quoteName('a.language') . ' = ' . $db->quoteName('l.lang_code') . ' )');
		$query->join('LEFT' , $db->quoteName('#__spbooking_accomodations','ac') . ' ON (' . $db->quoteName('a.accomodation_id') . ' = ' . $db->quoteName('ac.id') . ')');


		// Filter by search keyword
		if ($search = $this->getState('filter.search')) {
			$table_name = $this->getTable('Room', 'SpbookingTable')->getTableName();
			$searchConditions = SpbookingHelper::extractSearchFilter($search, $table_name);
			
			if (!empty($searchConditions)) {
				foreach($searchConditions as $condition) {
					$query->where($db->quoteName('a.' . $condition[0]) . ' ' . $condition[1] . ' ' . $db->quote($condition[2]));
				}
			}
		}

		// Filter by tags
		if ($tags = $this->getState('filter.transport_tags')) {
			if (is_array($tags) && !empty($tags)) {
				$rows = array_map(function($tag) use ($db){
					return $db->quoteName('a.transport_tags') . ' LIKE ' . $db->quote("%\"" . $tag . "\"%");
				}, $tags);

				if (!empty($rows)) {
					$query->where("(" . implode(' OR ', $rows) . ")");
				}
			}
		}

		// Filter by featured
		if ($featured = $this->getState('filter.featured')) {
			$query->where($db->quoteName('a.featured') . ' = ' . $db->quote($featured));
		}

		// Filter by accomodation
		if ($accomodation = $this->getState('filter.accomodation_id')) {
			$query->where($db->quoteName('a.accomodation_id') . ' = ' . $db->quote($accomodation));
		}

		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where($db->quoteName('a.published') . ' = ' . (int) $published);
		} elseif ($published === '') {
			$query->where($db->quoteName('a.published') . ' IN (0, 1)');
		}

		// Filter by access level.
		$access = $this->getState('filter.access');
		if (is_numeric($access)) {
			$query->where($db->quoteName('a.access') . ' = ' . (int) $access);
		}
		elseif (is_array($access)) {
			$access = ArrayHelper::toInteger($access);
			$access = implode(',', $access);
			$query->where($db->quoteName('a.access') . ' IN (' . $access . ')');
		}

		// Filter by language
		if ($language = $this->getState('filter.language')) {
			$query->where($db->quoteName('a.language') . ' = ' . $db->quote($language));
		}

		$orderCol 	= $this->getState('list.ordering','a.ordering');
		$orderDirn  = $this->getState('list.direction','desc');

		$order = $db->escape($orderCol) . ' ' . $db->escape($orderDirn);
		$query->order($order);

		return $query;
	}
}
	
