<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;

class SpbookingModelReviews extends ListModel
{
	public function __construct(array $config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = [
				'id', 'a.id',
				'title', 'a.title',
				'created_by', 'a.created_by',
				'created', 'a.created',
				'id', 'a.id',
				'reviewed_for', 'a.reviewed_for',
				'published', 'a.published'
			];
		}

		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.ordering', $direction = 'asc')
	{
		$app        = Factory::getApplication();
		$context    = $this->context;

		$search     = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$access     = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published  = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$language   = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '')
	{
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.language');

		return parent::getStoreId($id);
	}

	protected function getListQuery()
	{
		$app 	= Factory::getApplication();
		$state = $this->get('State');
		$db 	= Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.*, l.title_native as lang');
		$query->from($db->quoteName('#__spbooking_reviews', 'a'));
		$query->join('LEFT', $db->quoteName('#__languages', 'l') . ' ON (' . $db->quoteName('a.language') . ' = ' . $db->quoteName('l.lang_code') . ' )');

		// Filter by search keyword
		if ($search = $this->getState('filter.search'))
		{
			$table_name = $this->getTable('Review', 'SpbookingTable')->getTableName();
			$searchConditions = SpbookingHelper::extractSearchFilter($search, $table_name, 'review');

			if (!empty($searchConditions))
			{
				foreach ($searchConditions as $condition)
				{
					$query->where($db->quoteName('a.' . $condition[0]) . ' ' . $condition[1] . ' ' . $db->quote($condition[2]));
				}
			}
		}

		// Filter by review for
		if ($review_for = $this->getState('filter.reviewed_for'))
		{
			$query->where($db->quoteName('a.reviewed_for') . ' = ' . $db->quote($review_for));
		}

		// Filter by published state
		$published = $this->getState('filter.published');

		if (is_numeric($published))
		{
			$query->where($db->quoteName('a.published') . ' = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where($db->quoteName('a.published') . ' IN (0, 1)');
		}

		$orderCol 	= $this->getState('list.ordering', 'a.ordering');
		$orderDirn = $this->getState('list.direction', 'desc');

		$order = $db->escape($orderCol) . ' ' . $db->escape($orderDirn);
		$query->order($order);

		return $query;
	}

	public function getReviewFor($review_for, $id)
	{

		$result = null;

		if ($review_for == 'accomodation')
		{
			// Accomodation
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('ac.title')->from($db->quoteName('#__spbooking_accomodations', 'ac'))->where($db->quoteName('ac.id') . ' = ' . $db->quote($id));
			$db->setQuery($query);
			$result = $db->loadResult();
			unset($db, $query);
		}
		elseif ($review_for == 'package')
		{
			// Package
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('p.title')->from($db->quoteName('#__spbooking_packages', 'p'))->where($db->quoteName('p.id') . ' = ' . $db->quote($id));
			$db->setQuery($query);
			$result = $db->loadResult();
			unset($db, $query);
		}
		elseif ($review_for == 'transport')
		{
			// Package
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('t.title')->from($db->quoteName('#__spbooking_transports', 't'))->where($db->quoteName('t.id') . ' = ' . $db->quote($id));
			$db->setQuery($query);
			$result = $db->loadResult();
			unset($db, $query);
		}
		elseif ($review_for == 'place')
		{
			// Place
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('p.title')->from($db->quoteName('#__spbooking_places', 'p'))->where($db->quoteName('p.id') . ' = ' . $db->quote($id));
			$db->setQuery($query);
			$result = $db->loadResult();
			unset($db, $query);
		}

		return $result;
	}
}
