<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\String\StringHelper;
use Joomla\CMS\MVC\Model\AdminModel;

class SpbookingModelPackage extends AdminModel
{
	protected $text_prefix = 'COM_SPBOOKING';

	public function getTable($name = 'Package', $prefix = 'SpbookingTable', $config = array())
	{
		return Table::getInstance($name, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		$form = $this->loadForm('com_spbooking.package', 'package', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	public function loadFormData()
	{
		$data = Factory::getApplication()->getUserState('com_spbooking.edit.package.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}

	protected function canDelete($record)
	{
		if (!empty($record->id))
		{
			if ($record->published != -2)
			{
				return;
			}

			return parent::canDelete($record);
		}
	}

	protected function canEditState($record)
	{
		return parent::canEditState($record);
	}

	public function getItem($pk = null)
	{

		if ($item = parent::getItem($pk))
		{
			if (!empty($item->activities) && is_string($item->activities))
			{
				$item->activities = json_decode($item->activities);
			}

			if (!empty($item->overview) && is_string($item->overview))
			{
				$item->overview = json_decode($item->overview);
			}

			if (!empty($item->certificates) && is_string($item->certificates))
			{
				$item->certificates = json_decode($item->certificates);
			}

			if (!empty($item->additional_review) && is_string($item->additional_review))
			{
				$item->additional_review = json_decode($item->additional_review);
			}

			if (!empty($item->package_included) && is_string($item->package_included))
			{
				$item->package_included = json_decode($item->package_included);
			}

			if (!empty($item->package_excluded) && is_string($item->package_excluded))
			{
				$item->package_excluded = json_decode($item->package_excluded);
			}

			if (!empty($item->additional_services) && is_string($item->additional_services))
			{
				$item->additional_services = json_decode($item->additional_services);
			}

			if (!empty($item->package_tags) && is_string($item->package_tags))
			{
				$item->package_tags = json_decode($item->package_tags);
			}

			if (!empty($item->gallery) && is_string($item->gallery))
			{
				$item->gallery = json_decode($item->gallery, true);
			}

			if (!empty($item->major_activities) && is_string($item->major_activities))
			{
				$item->major_activities = json_decode($item->major_activities);
			}

			if (!empty($item->custom) && is_string($item->custom))
			{
				$item->custom = json_decode($item->custom);
			}

			return $item;
		}

		return parent::getItem($pk);
	}

	private function generateNewTitleLocally($alias, $title)
	{
		// Alter the title & alias
		$table = $this->getTable();

		while ($table->load(array('alias' => $alias)))
		{
			$title = StringHelper::increment($title);
			$alias = StringHelper::increment($alias, 'dash');
		}

		return array($title, $alias);
	}

	public function save($data)
	{
		$input 	= Factory::getApplication()->input;
		$task 	= $input->get('task');

		if ($task == 'save2copy')
		{
			$originalTable = clone $this->getTable();
			$originalTable->load($input->getInt('id'));

			if ($data['title'] == $originalTable->title)
			{
				list($title, $alias) = $this->generateNewTitleLocally($data['alias'], $data['title']);
				$data['title'] = $title;
				$data['alias'] = $alias;
			}
			else
			{
				if ($data['alias'] == $originalTable->alias)
				{
					$data['alias'] = '';
				}
			}

			$data['published'] = 0;
		}

		if (parent::save($data))
		{
			return true;
		}

		return false;
	}
}

