<?php


/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\String\StringHelper;

jimport('joomla.form.formfield');

class JFormFieldSprating extends FormField
{
	protected $type = 'Sprating';

	protected function getInput()
	{

		HTMLHelper::_('jquery.framework');

		// Document
		$doc = Factory::getDocument();

		// Attachments
		$doc->addScript(Uri::root(true) . '/administrator/components/com_spbooking/assets/js/sprating.js', [], []);

		// Css
		$doc->addStyleDeclaration("
            .star-wrapper .star {
                font-size: 20px;
                cursor: pointer;
            }

            .star-wrapper .star.fa-star {
                color: orange;
                text-shadow: 1px 1px 1px grey;
            }
            
            .categories{
                display: flex;
                justify-content: space-evenly;
            }

            .contents {
                width: 35%;
                padding: 10px;
            }

            .title {
                height: 70px;
            }
        "
		);

		// Get Advance Rating
		$reviewOptions = $this->form->getData()['advance_rating'];
		$ratingOptions = SpbookingHelper::getReviewOptions();

		$renderData    = !empty($reviewOptions) ? $reviewOptions : $ratingOptions;

		$star_class_o  = "fa fa-star-o";
		$star_class    = "fa fa-star";

		$html[] = '<div class="categories">';

		foreach ($renderData as $key => $val)
		{
			$value      = (!empty($val)) ? $val : '';
			$this->id   = "jform_advance_rating__$key";
			$this->name = "jform[advance_rating][$key]";
			$key        = StringHelper::str_ireplace('_', ' ', $key);

			$html[]     = "<div class='contents'>";
			$html[]     = "<div class='title'>$key</div>";
			$html[]     = "<div class='star-wrapper' id='" . $this->id . "' >";

			for ($i = 1; $i <= 5; $i++)
			{
				$html[] = "<span class='star " . $star_class_o . "' data-index='" . $i . "'></span>";
			}

			$html[] = "<input type='hidden' name='" . $this->name . "' value='" . $value . "'>";
			$html[] = "</div></div>";

			$doc->addScriptDeclaration("
                jQuery(function($){
                    $('#" . $this->id . "').spRating();
                });
            "
			);
		}

		$html[] = "</div>";

		return implode("\n", $html);
	}
}
