<?php
/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;

class JFormFieldSpmodal extends FormField
{
	protected $type = 'Spmodal';

	protected function getLabel()
	{
		return '';
	}

	protected function getInput()
	{
		$doc = Factory::getDocument();

		$component_name = Factory::getApplication()->input->get('option');
		$url = Route::_('index.php?option=' . $component_name . '&view=' . $this->element['view'] . '&tmpl=component&layout=modal');

		$btn_style = (isset($this->element['btn_style']) && $this->element['btn_style'] ) ? $this->element['btn_style'] : 'btn-success';

		$faIcon = JVERSION < 4 ? "fa fa-plus-circle" : "fas fa-plus-circle";
		$bsModal = JVERSION < 4 ? "data-" : "data-bs-";

		$html   = [];
		$html[] = "<a class='btn btn-small " .
				$btn_style . "' " . $bsModal . "toggle='modal' role='button' href='#" .
				$this->element['modal_id'] . "'><span class='" . $faIcon . "'></span> " .
				Text::_($this->element['button_text']) . "</a>";
		$html[] = "<div class='reload-holder' " . $bsModal . "reloader='" . $this->element['element'] . "'></div>";

		$footer     = [];
		$footer[]   = "<a type='button' class='btn' " . $bsModal . "dismiss='modal' aria-hidden='true' onclick='jQuery(\"#" .
					$this->element['modal_id'] . " iframe\").contents().find(\"#closeBtn\").click();'>" .
					Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . "</a>";

		$footer[]   = "<button type='button' class='btn btn-success spmodal-save' aria-hidden='true'>" .
					Text::_('JAPPLY') . "</button>";

		$modal_config = [
			'title'         => Text::_($this->element['modal_title']),
			'backdrop'      => (isset($this->element['backdrop']) && $this->element['backdrop']) ? $this->element['backdrop'] : 'static',
			'keyboard'      => (isset($this->element['keyboard']) && $this->element['keyboard']) ? $this->element['keyboard'] : true,
			'closeButton'   => (isset($this->element['close_button']) && $this->element['close_button']) ? $this->element['close_button'] : false,
			'url'           => $url,
			'height'        => (isset($this->element['height']) && $this->element['height']) ? $this->element['height'] : '400px',
			'width'         => (isset($this->element['width']) && $this->element['width']) ? $this->element['width'] : '800px',
			'bodyHeight'    => (isset($this->element['body_height']) && $this->element['body_height']) ? $this->element['body_height'] : '70',
			'modalWidth'    => (isset($this->element['modal_width']) && $this->element['modal_width']) ? $this->element['modal_width'] : '80',
			'footer'        => implode(" ", $footer)
		];

		$html[] = HTMLHelper::_(
			'bootstrap.renderModal',
			(string) $this->element['modal_id'],
			$modal_config
		);

		// $doc->addScript( Uri::base(true) . '/components/'.$component_name.'/assets/js/spmodal.js',  'text/javascript', true, false);
		$doc->addScript(Uri::base(true) . '/components/' . $component_name . '/assets/js/spmodal.js', [], ['defer' => true]);

		$doc->addScriptDeclaration("
            jQuery(function($){
                $(document).spmodal();
            });
        "
		);

		return implode("\n", $html);

	}

}
