<?php


/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Form\FormField;

jimport('joomla.form.formfield');
jimport('joomla.filesystem.file');

class JFormFieldSpgallery extends FormField
{
	protected $type = 'Spgallery';

	protected function getInput()
	{
		$doc        = Factory::getDocument();
		$input      = Factory::getApplication()->input;

		$component  = $input->get('option');
		$field_name = (string) ($this->element['name']);

		$html = array();
		$html[] = "<div class='spgallery'></div>";

		$doc->addScript(Uri::root(true) . '/administrator/components/' . $component . '/assets/js/spgallery.js');
		$doc->addStylesheet(Uri::root(true) . '/administrator/components/' . $component . '/assets/css/spgallery.css');
		$doc->addStylesheet('https://fonts.googleapis.com/css?family=Ubuntu');

		// $doc->addScript(Uri::root(true) . '/administrator/components/'.$component.'/assets/js/spgallery.js','text/javascript', true, false);
		// $doc->addStylesheet(Uri::root(true) . '/administrator/components/'.$component.'/assets/css/spgallery.css');
		// $doc->addStylesheet('https://fonts.googleapis.com/css?family=Ubuntu');

		if (!empty($this->value) && is_array($this->value))
		{
			$value = json_encode($this->value);
		}
		else
		{
			$value = '';
		}

		$doc->addScriptDeclaration("
            jQuery(function($){
                $('.spgallery').spGallery({
                    'baseUrl': '" . Uri::root() . "',
                    'host': '" . Uri::root() . "administrator/index.php?option=" . $component . "',
                    'spgalleryId': '" . $this->id . "',
                    'fieldName': '" . $this->name . "',
                    'fieldValue': '" . $value . "',
                    'indexName': '" . $field_name . "',
                    'uploadPath': 'images/spbooking/gallery',
                    'media': {
                        'modalOkBtn': 'Insert',
                        'modalRemoveBtn': 'Remove'
                    }
                });
            });
        "
		);

		return implode("\n", $html);
	}
}
