<?php

/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;

jimport('joomla.form.formfield');

class JFormFieldSpcategories extends FormField
{
	  protected $type = 'Spcategories';

	public function getCategories($itemtype = 'accomodation')
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__spbooking_categories'));
		$query->where($db->quoteName('category_for') . " = " . $db->quote($itemtype));
		$query->where($db->quoteName('published') . " = 1");
		$query->order('ordering DESC');
		  $db->setQuery($query);

		return $db->loadObjectList();
	}

	protected function getInput()
	{
		  $categoryfor    = !empty((string) $this->element['categoryfor']) ? (string) $this->element['categoryfor'] : 'accomodation';
		  $categories = $this->getCategories($categoryfor);

		  $options[] = HTMLHelper::_('select.option', '', '');

		foreach ($categories as $key => $category)
		{
				$options[] = HTMLHelper::_('select.option', $category->id, $category->title);
		}

		  return HTMLHelper::_('select.genericlist', $options, $this->name, '', 'value', 'text', $this->value);
	}
}
