<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\MVC\Model\ListModel;

class SpbookingModelDashboard extends ListModel
{
	public function __construct(array $config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = [
				'id','a.id',
				'title', 'a.title',
				'ordering', 'a.ordering',
				'created_by', 'a.created_by',
				'created', 'a.created',
				'id', 'a.id'
			];
		}

		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.ordering', $direction = 'asc')
	{
		$app = Factory::getApplication();
		$context = $this->context;

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$language = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '')
	{
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.language');

		return parent::getStoreId($id);
	}

	public function getAccomodationsCount()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select("COUNT(id) as total_accomodations")
			->from($db->quoteName('#__spbooking_accomodations'))
			->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);

		$result = $db->loadResult();

		return !empty($result) ? $result : 0;
	}
	public function getPackagesCount()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select("COUNT(id) as total_packages")
			->from($db->quoteName('#__spbooking_packages'))
			->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);

		$result = $db->loadResult();

		return !empty($result) ? $result : 0;
	}
	public function getTransportsCount()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select("COUNT(id) as total_transports")
			->from($db->quoteName('#__spbooking_transports'))
			->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);

		$result = $db->loadResult();

		return !empty($result) ? $result : 0;
	}
	public function getPlacesCount()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select("COUNT(id) as total_places")
			->from($db->quoteName('#__spbooking_places'))
			->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);

		$result = $db->loadResult();

		return !empty($result) ? $result : 0;
	}

	public function getBookingInfo($limit = 10, $order_by = 'created', $order_dirn = 'desc')
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('published') . ' = 1')
			->order($db->quoteName($order_by) . ' ' . $order_dirn);
		$query->setLimit($limit);
		$db->setQuery($query);
		$result = $db->loadObjectList();

		return !empty($result) ? $result : array();
	}

	public function getPieData()
	{

		$data = array();
		$today = new Date;
		$today = $today->format('Y-m-d');

		$week = new Date('now -1 week');
		$week = $week->format('Y-m-d');

		$month = new Date('now -1 month');
		$month = $month->format('Y-m-d');

		$year = new Date('now -1 year');
		$year = $year->format('Y-m-d');

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(total_paid)')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('checkin') . ' = ' . $db->quote($today));
		$db->setQuery($query);
		$earn_today = $db->loadResult();
		$data['today'] = !empty($earn_today) ? $earn_today : 0;
		unset($db, $query);

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(total_paid)')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('checkin') . ' <= ' . $db->quote($today))
			->where($db->quoteName('checkin') . ' >= ' . $db->quote($week));
		$db->setQuery($query);
		$earn_week = $db->loadResult();
		$data['week'] = !empty($earn_week) ? $earn_week : 0;
		unset($query, $db);

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(total_paid)')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('checkin') . ' <= ' . $db->quote($today))
			->where($db->quoteName('checkin') . ' >= ' . $db->quote($month));
		$db->setQuery($query);
		$earn_month = $db->loadResult();
		$data['month'] = !empty($earn_month) ? $earn_month : 0;
		unset($query, $db);

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(total_paid)')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('checkin') . ' <= ' . $db->quote($today))
			->where($db->quoteName('checkin') . ' >= ' . $db->quote($year));
		$db->setQuery($query);
		$earn_year = $db->loadResult();
		$data['year'] = !empty($earn_year) ? $earn_year : 0;

		return $data;
	}

	public function getDailyBookingCount($date)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(id) AS total')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('published') . ' = 1')
			->where($db->quoteName('checkin') . ' = ' . $db->quote($date));

		$db->setQuery($query);
		$results = $db->loadResult();

		return !empty($results) ? $results : 0;
	}

	public function getLatestReviews($limit = 5)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__spbooking_reviews'))
			->where($db->quoteName('published') . ' = 1')
			->setLimit($limit);

		$query->order($db->quoteName('created') . ' DESC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return !empty($result) ? $result : array();
	}
}

