<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;

class SpbookingModelBookings extends ListModel
{
	public function __construct(array $config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = [
				'id','a.id',
				'created_by', 'a.created_by',
				'created', 'a.created',
				'id', 'a.id',
				'booking_for', 'a.booking_for',
				'checkin', 'a.checkin',
				'checkout', 'a.checkout',
				'booking_status', 'a.booking_status',
				'booked_id', 'a.booked_id'
			];
		}

		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.ordering', $direction = 'asc')
	{
		$app = Factory::getApplication();
		$context = $this->context;

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$language = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '')
	{
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.language');

		return parent::getStoreId($id);
	}

	protected function getListQuery()
	{
		$app 	= Factory::getApplication();
		$state = $this->get('State');
		$db 	= Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.*, l.title_native as lang');
		$query->from($db->quoteName('#__spbooking_bookings', 'a'));
		$query->join('LEFT', $db->quoteName('#__languages', 'l') . ' ON (' . $db->quoteName('a.language') . ' = ' . $db->quoteName('l.lang_code') . ' )');

		if ($booking_for = $this->getState('filter.booking_for'))
		{
			$query->where($db->quoteName('a.booking_for') . ' = ' . $db->quote($booking_for));
		}

		if ($booking_status = $this->getState('filter.booking_status'))
		{
			$query->where($db->quoteName('a.booking_status') . ' = ' . $db->quote($booking_status));
		}

		if ($checkin = $this->getState('filter.checkin'))
		{
			$query->where($db->quoteName('a.checkin') . ' >= ' . $db->quote($checkin));
		}

		if ($checkout = $this->getState('filter.checkout'))
		{
			$query->where($db->quoteName('a.checkin') . ' <= ' . $db->quote($checkout));
		}

		if ($created_from = $this->getState('filter.created_from'))
		{
			$query->where($db->quoteName('a.created') . ' >= ' . $db->quote($created_from));
		}

		if ($created_to = $this->getState('filter.created_to'))
		{
			$query->where($db->quoteName('a.created') . ' <= ' . $db->quote($created_to));
		}

		// Filter by search keyword
		if ($search = $this->getState('filter.search'))
		{
			$table_name = $this->getTable('Booking', 'SpbookingTable')->getTableName();
			$searchConditions = SpbookingHelper::extractSearchFilter($search, $table_name, 'booked_id');

			if (!empty($searchConditions))
			{
				foreach ($searchConditions as $condition)
				{
					$query->where($db->quoteName('a.' . $condition[0]) . ' ' . $condition[1] . ' ' . $db->quote($condition[2]));
				}
			}
		}

		// Filter by published state
		$published = $this->getState('filter.published');

		if (is_numeric($published))
		{
			$query->where($db->quoteName('a.published') . ' = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where($db->quoteName('a.published') . ' IN (0, 1)');
		}

		$orderCol 	= $this->getState('list.ordering', 'a.ordering');
		$orderDirn = $this->getState('list.direction', 'desc');

		$order = $db->escape($orderCol) . ' ' . $db->escape($orderDirn);
		$query->order($order);

		return $query;
	}
}

