<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\MVC\Model\ListModel;

class SpbookingModelAccomodations extends ListModel {
	public function __construct(array $config = array()) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = [
				'id','a.id',
				'title', 'a.title',
				'category_id', 'a.category_id',
				'created_by', 'a.created_by',
				'accomodation_tags', 'a.accomodation_tags',
				'created', 'a.created',
				'access', 'a.access', 'access_level',
				'created_on','a.created_on',
				'ordering', 'a.ordering',
				'language','a.language',
				'country', 'a.country',
				'city', 'a.city',
				'featured', 'a.featured',
				'id', 'a.id',
				'published', 'a.published'
			];
		}
		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.ordering', $direction = 'asc') {
		$app = Factory::getApplication();
		$context = $this->context;

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$courseId = $this->getUserStateFromRequest($this->context . '.filter.category_id', 'filter_category_id');
		$this->setState('filter.category_id', $courseId);

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$language = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
		$this->setState('filter.language', $language);

		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '') {
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.category_id');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.language');

		return parent::getStoreId($id);
	}

	protected function getListQuery() {
		$app 	= Factory::getApplication();
		$state = $this->get('State');
		$db 	= Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.*, l.title_native as lang, c.title as category');
		$query->from($db->quoteName('#__spbooking_accomodations', 'a'));
		$query->join('LEFT', $db->quoteName('#__spbooking_categories','c') . ' ON (' . $db->quoteName('a.category_id') . ' = ' . $db->quoteName('c.id') . ')');
		$query->join('LEFT' , $db->quoteName('#__languages', 'l') . ' ON (' . $db->quoteName('a.language') . ' = ' . $db->quoteName('l.lang_code') . ' )');

		// Join over the users for the checked out user.
		$query->select('uc.name AS editor')
			->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');

		$query->select('ua.name AS author_name')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');

		$query->select('ug.title AS access_title')
			->join('LEFT','#__viewlevels AS ug ON ug.id = a.access');

		if ($search = $this->getState('filter.search')) {
			$table_name = $this->getTable('Accomodation', 'SpbookingTable')->getTableName();
			$searchConditions = SpbookingHelper::extractSearchFilter($search, $table_name);
			
			if (!empty($searchConditions)) {
				foreach($searchConditions as $condition) {
					$query->where($db->quoteName('a.' . $condition[0]) . ' ' . $condition[1] . ' ' . $db->quote($condition[2]));
				}
			}
		}

		if ($category = $this->getState('filter.category_id')) {
			$query->where($db->quoteName('a.category_id') . ' = ' . $category);
		}

		if ($country = $this->getState('filter.country')) {
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote($country));
		}
		
		if ($city = $this->getState('filter.city')) {
			$query->where($db->quoteName('a.city') . ' = ' . $db->quote($city));
		}
		
		if ($tags = $this->getState('filter.accomodation_tags')) {
			if (is_array($tags) && !empty($tags)) {
				$rows = array_map(function($tag) use ($db){
					return $db->quoteName('a.accomodation_tags') . ' LIKE ' . $db->quote("%\"" . $tag . "\"%");
				}, $tags);

				if (!empty($rows)) {
					$query->where("(" . implode(' OR ', $rows) . ")");
				}
			}
		}

		if ($featured = $this->getState('filter.featured')) {
			$query->where($db->quoteName('a.featured') . ' = ' . $db->quote($featured));
		}

		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where($db->quoteName('a.published') . ' = ' . (int) $published);
		} elseif ($published === '') {
			$query->where($db->quoteName('a.published') . ' IN (0, 1)');
		}

		// Filter by access level.
		$access = $this->getState('filter.access');
		if (is_numeric($access)) {
			$query->where($db->quoteName('a.access') . ' = ' . (int) $access);
		}
		elseif (is_array($access)) {
			$access = ArrayHelper::toInteger($access);
			$access = implode(',', $access);
			$query->where($db->quoteName('a.access') . ' IN (' . $access . ')');
		}

		// Filter by language
		if ($language = $this->getState('filter.language')) {
			$query->where($db->quoteName('a.language') . ' = ' . $db->quote($language));
		}

		if ($category = $this->getState('filter.category_id')) {
			$query->where($db->quoteName('a.category_id') . ' = ' . $db->quote($category));
		}

		$orderCol 	= $this->getState('list.ordering','a.ordering');
		$orderDirn = $this->getState('list.direction','desc');

		$order = $db->escape($orderCol) . ' ' . $db->escape($orderDirn);
		$query->order($order);
		
		return $query;
	}
}
	
