<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Installer\Installer;

class com_spbookingInstallerScript
{

	public function uninstall($parent)
	{

		$extensions = array(
			array('type' => 'module', 'name' => 'mod_spbooking_accomodation'),
			array('type' => 'module', 'name' => 'mod_spbooking_destination'),
			array('type' => 'module', 'name' => 'mod_spbooking_packages'),
			array('type' => 'module', 'name' => 'mod_spbooking_search'),
			array('type' => 'module', 'name' => 'mod_spbooking_transports'),
			array('type' => 'plugin', 'name' => 'spbookingupdater'),
			array('type' => 'plugin', 'name' => 'spbookingprofile')
		);

		foreach ($extensions as $key => $extension)
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('extension_id')));
			$query->from($db->quoteName('#__extensions'));
			$query->where($db->quoteName('type') . ' = ' . $db->quote($extension['type']));
			$query->where($db->quoteName('element') . ' = ' . $db->quote($extension['name']));
			$db->setQuery($query);
			$id = $db->loadResult();

			if (isset($id) && $id)
			{
				$installer = new Installer;
				$result = $installer->uninstall($extension['type'], $id);
			}
		}
	}

	function postflight($type, $parent)
	{

		$db   = Factory::getDbo();
		$date = Factory::getDate()->toSql();

		$extensions = array(
			array('type' => 'module', 'name' => 'mod_spbooking_accomodation'),
			array('type' => 'module', 'name' => 'mod_spbooking_destination'),
			array('type' => 'module', 'name' => 'mod_spbooking_packages'),
			array('type' => 'module', 'name' => 'mod_spbooking_search'),
			array('type' => 'module', 'name' => 'mod_spbooking_transports'),
			array('type' => 'plugin', 'name' => 'spbookingupdater', 'group' => 'system'),
			array('type' => 'plugin', 'name' => 'spbookingprofile', 'group' => 'user')
		);

		foreach ($extensions as $key => $extension)
		{
			$ext = $parent->getParent()->getPath('source') . '/' . $extension['type'] . 's/' . $extension['name'];
			$installer = new Installer;
			$installer->install($ext);

			if ($extension['type'] == 'plugin')
			{
				$query = $db->getQuery(true);

				$fields = array($db->quoteName('enabled') . ' = 1');
				$conditions = array(
					$db->quoteName('type') . ' = ' . $db->quote($extension['type']),
					$db->quoteName('element') . ' = ' . $db->quote($extension['name']),
					$db->quoteName('folder') . ' = ' . $db->quote($extension['group'])
					);

				$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
				$db->setQuery($query);
				$db->execute();
			}
		}

		$columns = array('title', 'alias', 'published', 'language', 'access', 'ordering', 'created_by', 'created');

		// Check if 'day' and 'long' exist in the table
		$query = $db->getQuery(true)
			->select($db->quoteName('alias'))
			->from($db->quoteName('#__spbooking_packagetypes'))
			->whereIn($db->quoteName('alias'), ['day','long']);

		$db->setQuery($query);
		$results = $db->loadObjectList();

		$alias = array_column($results, 'alias');

		// Insert 'day' if it doesn't exist
		if (!in_array('day', $alias))
		{
			$day      = array($db->quote('Day Tour'), $db->quote('day'), 1, $db->quote('*'), 1, 0, 0, $db->quote($date));
			$values[] = implode(', ', $day);
		}

		// Insert 'long' if it doesn't exist
		if (!in_array('long', $alias))
		{
			$long     = array($db->quote('Long'), $db->quote('long'), 1, $db->quote('*'), 1, 0, 0, $db->quote($date));
			$values[] = implode(', ', $long);
		}

		if (!empty($values))
		{
			$query = $db->getQuery(true)
				->insert($db->quoteName('#__spbooking_packagetypes'))
				->columns($db->quoteName($columns))
				->values($values);
			$db->setQuery($query);
			$db->execute();
		}

		$component_version = $parent->getManifest()->version;

		if (empty($component_version))
		{
			$component_version = '0.1';
		}

		?>
		<link type="text/css" rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css"/>
		<style tyle="text/css">
			.spai-wrapper {
				background-image: url(<?php echo Uri::root(true) . '/administrator/components/com_spbooking/assets/images/background.svg'; ?>);
				background-repeat: no-repeat;
				background-color: #61D6AF;
				background-position: bottom;
				background-size: contain;
				font-family: "HelveticaNeue-Light", "Helvetica Neue Light", "Helvetica Neue", Helvetica, Arial, "Lucida Grande", sans-serif;
				color: #ffffff;
				margin-bottom: 50px;
				border-radius: 4px;
			}
			.spai-wrapper a {
				text-decoration: none;
			}

			.spai-description-body a {
				color: #979797;
			}

			.spai-top-header a {
				color: #fff;
			}
		
			.is-uppercase {
				text-transform: uppercase;
			}

			.spai-wrapper .spai-inner-container {
				padding: 50px 180px;
			}

			.spai-wrapper .spai-top-header {
				display: flex;
				flex-direction: column;
				justify-content: center;
				text-align: center;
			}

			.spai-wrapper .spai-top-header > .spai-ext-name {
				font-weight: bold;
				font-size: 15px;
			}

			.spai-top-header .spai-label {
				background: #28B787;
				padding: 3px 15px;
				border-radius: 11px;
				margin: 10px 0 0;
				display: inline-block;
			}

			.spai-wrapper .spai-description-body {
				background: #ffffff;
				box-shadow: 0 2px 15px 0 #00000012;
				border-radius: 4px;
				color: #959595;
				text-align: center;
				padding: 40px 100px 40px;
				margin-top: 40px;
			}

			.spai-wrapper .spai-related-templates {
				margin: 50px 0 0;
			}

			.spai-wrapper .spai-followus-links {
				margin: 50px 0 0;
				font-size: 16px;
			}

			.spai-followus-links span.fa {
				padding: 10px;
			}

			.spai-followus-links .social-facebook {
				color: #3357A2;
			}

			.spai-followus-links .social-twitter {
				color: #00ACE6;
			}

			.spai-followus-links .social-youtube {
				color: #FF0000;
			}

			.spai-followus-links .social-joomla {
				color: #0068c3;
			}

			.spai-description-text {
				font-size: 16px;
				line-height: 25px;
			}

			.spai-rt-msg {
				font-size: 16px;
			}

			.spai-followus-links a > span {
				font-size: 20px;
			}

			.spai-followus-links a {
				transition: .3s;
			}
			.spai-followus-links:hover a {
				opacity: .3;    
			}
			.spai-followus-links a:hover {
				opacity: 1;    
			}
		</style>

		<div class="spai-wrapper">
			<div class="spai-inner-container">
				<div class="spai-top-header">
					<div class="spai-ext-logo">
						<img src="<?php echo Uri::root(true) . '/administrator/components/com_spbooking/assets/images/logo.svg' ?>" alt="" width="50" height="30">
					</div>
					<div class="spai-ext-name is-uppercase">
						<a href="<?php echo Route::_('index.php?option=com_spbooking'); ?>" class="">SP Booking</a>
					</div>
					<div class="spai-ext-version">
						<span class="spai-label">
							Version <?php echo $component_version; ?>
						</label>
					</div>
				</div>
		
				<div class="spai-description-body">
					<div class="spai-description-text">
						<p class="desc">SP Booking is a complete and robust travel booking solution for Joomla. The extension provides each and every feature necessary for travel booking and related websites. With rich presentation of the facilities utilizing multimedia contents, SP Booking is a full-fledged travel management system for any travel agency, tour operator, car hire, hotel booking, villa rental, and flight booking website.</p>
					</div>
		
					<div class="spai-related-templates">
						<div class="spai-rt-msg">
							<p>Try all the templates powerd by the component <a href="<?php echo Route::_('index.php?option=com_spbooking'); ?>"><strong>SP Booking</strong></a></p>
						</div>
						<a href="https://www.joomshaper.com/downloads/template/travus" target="_blank">
							<img src="<?php echo Uri::root(true) . '/administrator/components/com_spbooking/assets/images/travus-logo.svg' ?>" alt="" width="150" height="40">
						</a>
					</div>
		
					<div class="spai-followus-links">
						<span>Follow us: </span>
						<a href="http://www.facebook.com/joomshaper" target="_blank">
							<span class="fa fa-facebook social-facebook" title="Facebook"></span>
						</a>
						<a href="http://twitter.com/joomshaper" target="_blank">
							<span class="fa fa-twitter social-twitter" title="Twitter"></span>
						</a>
						<a href="http://youtube.com/user/joomshaper" target="_blank">
							<span class="fa fa-youtube social-youtube" title="Youtube"></span>
						</a>
						<a href="http://extensions.joomla.org/profile/profile/details/138128" target="_blank">
							<span class="fa fa-joomla social-joomla" title="Joomla Extensions Directory"></span>
						</a>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

