<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Image\Image;
use Joomla\CMS\Filesystem\File;
use Joomla\String\StringHelper;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingHelper extends ContentHelper
{

	public static function addSubmenu($vName)
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_DASHBOARD'),
			'index.php?option=com_spbooking&view=dashboard',
			$vName == 'dashboard'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_CATEGORIES'),
			'index.php?option=com_spbooking&view=categories',
			$vName == 'categories'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'),
			'index.php?option=com_spbooking&view=additionalservices',
			$vName == 'additionalservices'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_ACCOMODATIONS'),
			'index.php?option=com_spbooking&view=accomodations',
			$vName == 'accomodations'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_ROOMS'),
			'index.php?option=com_spbooking&view=rooms',
			$vName == 'rooms'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_COUPONS'),
			'index.php?option=com_spbooking&view=coupons',
			$vName == 'coupons'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_PACKAGES'),
			'index.php?option=com_spbooking&view=packages',
			$vName == 'packages'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_PACKAGE_TYPES'),
			'index.php?option=com_spbooking&view=packagetypes',
			$vName == 'packagetypes'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_TRANSPORTS'),
			'index.php?option=com_spbooking&view=transports',
			$vName == 'transports'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_PLACES'),
			'index.php?option=com_spbooking&view=places',
			$vName == 'places'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_BOOKINGS'),
			'index.php?option=com_spbooking&view=bookings',
			$vName == 'bookings'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_TAGS'),
			'index.php?option=com_spbooking&view=tags',
			$vName == 'tags'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPBOOKING_TITLE_REVIEWS'),
			'index.php?option=com_spbooking&view=reviews',
			$vName == 'reviews'
		);

		// Every view which is suppose to show in the left side will be added here
	}

	/**
	 * format and render price with currency information
	 * @param price | price value
	 * @param currency | in which currency the price is shown
	 * @param format | currency format. short and long two format allowed
	 * @param position | position of the currency placed. Left and Right are two available options.
	 * @param allow_space | 1 for allow space between currency and price, 0 otherwise.
	 * @param decimal | Sets the number of decimal points.
	 * @param dec_point | Sets the separator for the decimal point.
	 * @param thousand_sep | Sets the thousands separator.
	 *
	 * @return price with format
	 */
	public static function formatPrice($price, $currency = null, $format = null, $position = null, $allow_space = false, $decimal = 0, $dec_point = '.', $thousands_sep=',')
	{
		$cParams = ComponentHelper::getParams('com_spbooking');

		if (!isset($price) || !is_numeric($price))
		{
			$price = 0;
		}

		$price = number_format($price, $decimal, $dec_point, $thousands_sep);

		if (empty($currency))
		{
			$currency = $cParams->get('currency', 'USD:$');
		}

		if (empty($format))
		{
			$format = $cParams->get('currency_type', 'short');
		}

		if (empty($position))
		{
			$position = $cParams->get('currency_position', 'left');
		}

		$price_string = '';
		$currency = explode(':', $currency, 2);

		if ($format == 'short')
		{
			$currency = $currency[1];
		}
		else
		{
			$currency = $currency[0];
		}

		if ($position == 'left')
		{
			if ($allow_space)
			{
				$price_string .= $currency . ' ' . $price;
			}
			else
			{
				$price_string .= $currency . $price;
			}
		}
		else
		{
			if ($allow_space)
			{
				$price_string .= $price . ' ' . $currency;
			}
			else
			{
				$price_string .= $price . $currency;
			}
		}

		return $price_string;
	}

	public static function makeThumbs($image)
	{
		$params 		= ComponentHelper::getParams('com_spbooking');
		$thumb 			= $params->get('thumbnail', '360x348');
		$thumb_large 	= $params->get('thumbnail_large', '1080x1200');
		$thumbs 		= array($thumb,$thumb_large);

		$filteredImage = explode('?', $image);
		$image = $filteredImage[0];

		if (!empty($image) && !empty($thumbs))
		{
			jimport('joomla.filesystem.file');
			jimport('joomla.filesystem.folder');
			jimport('joomla.image.image');
			$image = JPATH_ROOT . '/' . $image;
			$sizes = $thumbs;

			if (File::exists($image))
			{
				$image = new Image($image);
				$image->createThumbs($sizes, 5);
			}
		}
	}

	public static function extractSearchFilter($searchString = '', $tbl_name = '', $default_key = 'title', $default_operator = 'like')
	{
		// If not search string given, return false
		if (empty($searchString) || empty($tbl_name))
		{
			return false;
		}

		// Get the columns of the table where to search
		$db = Factory::getDbo();
		$columns = $db->getTableColumns($tbl_name);
		$columns = array_keys($columns);

		// Explode the searchString with bitwise or(|)
		$searches = explode('|', $searchString);
		$conditions = array();
		$hasError = false;

		if (!empty($searches))
		{
			// Extract key=>value pairs with colon(:)
			$fields = array();

			foreach ($searches as $k => $search)
			{
				$field = explode(':', $search);

				if (count($field) >= 2)
				{
					// Key value pair found
					$key = trim($field[0]);
					$value = trim($field[1]);
					$length = strlen($value);

					// Check if the key not in the database
					if (!in_array($key, $columns))
					{
						throw new \Exception('No such a key "' . $key . '" exists in the database columns.', 404);
						$hasError = true;

						// Return false;
					}

					// If % is found or not
					if (substr_count($value, '%') === 0)
					{
						// Exact value searching
						$conditions[] = array($key, '=', $value);
					}
					elseif (substr_count($value, '%') === 1)
					{
						if (strpos($value, '%') === 0)
						{
							// Search like %value
							$conditions[] = array($key, 'like', '%' . trim($value, '%'));
						}
						elseif (strpos($value, '%') === ($length - 1))
						{
							// Search like value%
							$conditions[] = array(trim($key), 'like', trim($value, '%') . '%');
						}
						else
						{
							// Doesn't sense anything
							throw new \Exception('The % must positioned at the beginning or end of the search string.', 404);
							$hasError = true;

							// Return false;
						}
					}
					elseif (substr_count($value, '%') === 2)
					{
						// Search like %value%
						$conditions[] = array(trim($key), 'like', '%' . trim($value, '%') . '%');
					}
				}
				else
				{
					// Search in title
					if ($default_operator == 'like')
					{
						if (substr_count(trim($field[0]), '%') === 0)
						{
							$conditions[] = array($default_key, $default_operator, '%' . trim($field[0]) . '%');
						}
						else
						{
							$conditions[] = array($default_key, $default_operator, trim($field[0]));
						}
					}
					else
					{
						$conditions[] = array($default_key, $default_operator, trim($field[0]));
					}
				}
			}
		}
		else
		{
			return false;
		}

		if ($hasError)
		{
			return false;
		}

		return $conditions;
	}

	/**
	 * Get the joomla version
	 *
	 */
	public static function getJoomlaVersion($type = 'major')
	{
		$version = JVERSION;
		list ($major, $minor, $patch) = explode('.', $version);

		if (strpos($patch, '-') !== false)
		{
			$patch = explode('-', $patch)[0];
		}

		switch ($type)
		{
			case 'minor':
				return (int) $minor;
			case 'patch':
				return (int) $patch;
			case 'major':
			default:
				return (int) $major;
		}
	}

	/**
	 * Return Review Options
	 *
	 * @return array
	 * @since  2.1.0
	 */
	public static function getReviewOptions()
	{

		$cparams   = ComponentHelper::getParams('com_spbooking');
		$newRating = $cparams->get('new_rating');
		$newRatingFields = $cparams->get('new_rating_fields');

		$defaultReviewCategories = array(
			'safty_security' => 0,
			'maintenance' => 0,
			'cleanliness' => 0,
			'service' => 0,
			'hospitality' => 0
		);

		$newReviewCategories = array();

		if (is_object($newRatingFields) && $newRating)
		{
			foreach ($newRatingFields as $value)
			{
				if (empty(trim($value->rating_title)))
				{
					return $defaultReviewCategories;
				}

				$key = StringHelper::str_ireplace(' ', '_', $value->rating_title);
				$newReviewCategories[$key] = 0;
			}

			return $newReviewCategories;
		}

		return $defaultReviewCategories;
	}
}


