<?php


/**
 * @package com_spproperty
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\MVC\Controller\AdminController;

jimport('joomla.filesystem.file');

class SpbookingControllerSpgallery extends AdminController
{

	public function upload()
	{
		ini_set('post_max_size', '64M');
		ini_set('upload_max_filesize', '64M');
		$app    = Factory::getApplication();
		$input  = $app->input;

		$file = $input->files->get('file');
		$filename = File::makeSafe($file['name']);

		$path = base64_decode($input->get('uploadPath'));

		$src = $file['tmp_name'];
		$dest = JPATH_ROOT . '/' . $path;

		$output = array();

		if (!Folder::exists($dest))
		{
			Folder::create($dest, 0755);
		}

		$image_path = $dest . '/' . $filename;

		if (File::upload($src, $image_path))
		{
			$output['path'] = base64_encode($path . '/' . $filename);
			$output['alt_text'] = $filename;
			$output['status_code'] = 200;
		}
		else
		{
			$output['path'] = '';
			$output['alt_text'] = '';
			$output['status_code'] = 400;
		}

		if (!empty($output))
		{
			print_r(json_encode($output));
		}
		else
		{
			print_r(400);
		}

		die();
	}

	public function newFolder()
	{
		$app    = Factory::getApplication();
		$input  = $app->input;

		$directory = $input->get('directory');
		$directory = base64_decode($directory);
		$return = 0;

		if (!empty($directory))
		{
			$directory = JPATH_ROOT . '/' . $directory;

			if (!Folder::exists($directory))
			{
				if (Folder::create($directory, 0755))
				{
					$return = 200;
				}
				else
				{
					$return = 400;
				}
			}
			else
			{
				$return = 0;
			}
		}

		echo $return;
		die();
	}

	public function getAllPossibleDirectories()
	{
		$app    = Factory::getApplication();
		$input  = $app->input;

		$path = $input->get('path');

		if (!empty($path))
		{
			$path = base64_decode($path);
		}

		$path = JPATH_ROOT . '/' . $path;

		$folders = Folder::listFolderTree($path, '.', 10000);
		$options = array();

		foreach ($folders as $folder)
		{
			$options[] = $folder['relname'];
		}

		echo json_encode($options);
		die();
	}

	public function getDirectoryContents()
	{
		$app    = Factory::getApplication();
		$input  = $app->input;

		$path = $input->get('path');

		if (!empty($path))
		{
			$path = base64_decode($path);
		}

		$folders = Folder::listFolderTree(JPATH_ROOT . '/' . $path, '.', 1);
		$files = Folder::files(JPATH_ROOT . '/' . $path, '.+.(jpg|png|jpeg|gif|bmp)$', false);

		$output = array(
			'folders' => $folders,
			'files' => $files,
			'path' => $path
		);

		echo json_encode($output);
		die();

	}

	public function removeFiles()
	{
		$app    = Factory::getApplication();
		$input  = $app->input;

		$files = $input->get('files');

		$output = array();

		if (!empty($files))
		{
			$files = base64_decode($files);
			$files = json_decode($files, true);

			foreach ($files as $file)
			{
				$file = JPATH_ROOT . '/' . $file;

				if (File::exists($file))
				{
					File::delete($file);
				}
			}
		}

		echo "200";
		die();
	}
}
