<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;

class SpbookingController extends BaseController
{

	/**
	 * Display method for the controller
	 *
	 * @param   boolean $cachable   If true, the view output will be cached
	 * @param   array   $urlparams  An array of safe url parameters and their variable types, for valid values see {@link InputFilter::clean()}.
	 *
	 * @return  static  A \BaseController object to support chaining.
	 *
	 * @since 1.0.0
	 * @throws  \Exception
	 */
	public function display($cachable = false, $urlparams = [])
	{
		$view = $this->input->get('view', 'dashboard');
		$layout = $this->input->get('layout', 'default');
		$id = $this->input->getInt('id');
		$this->input->set('view', $view);

		if ($view == 'accomodation' && $layout == 'edit' && !$this->checkEditId('com_spbooking.edit.accomodation', $id))
		{
			Factory::getApplication()->enqueueMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			$this->setRedirect(Route::_('index.php?option=com_spbooking&view=accomodations', false));

			return false;
		}

		parent::display($cachable, $urlparams);

		return $this;
	}
}
