;(function($, window, document, undefined) {

    var name = "spRating";
    function Plugin(element, options) {
        this.element = element;
        this.name = name;
        this._defaults = $.fn.defaults;
        this.options = $.extend({}, this._defaults, options);
        this.set_value = $(this.element).find('input').val() == '' ? 0 : $(this.element).find('input').val();

        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.renderSavedStars();
            this.hoverEffect();
            this.clickEffect();
        },

        cacheElement: function() {
            this.$element = $(this.element);
        }, 

        renderSavedStars: function() {
            this.$element.find(".star").slice(0, this.set_value).each(function() {
                if ($(this).hasClass('fa-star-o')) {
                    $(this).removeClass('fa-star-o').addClass('fa-star');
                }
            })
        },
        
        hoverEffect: function() {
            let self = this;
            this.$element.find('.star').on('mouseenter', function (e) {
                let _index = $(this).data('index');
                self.$element.find('.star').slice(self.set_value, _index).each(function () {
                    if ($(this).hasClass('fa-star-o')) {
                        $(this).removeClass('fa-star-o').addClass('fa-star');
                    }
                });

                self.$element.find('.star').on('mouseleave', function (e) {
                    self.removeSelection(self.set_value, _index);
                })

            });
        },
        
        clickEffect: function() {
            let self = this;
            this.$element.find('.star').on('click', function(e) {
                self.removeAllSelection();
                let _index = $(this).data('index');
                self.$element.find('.star').slice(0, _index).each(function() {
                    if ($(this).hasClass('fa-star-o')) {
                        $(this).removeClass('fa-star-o').addClass('fa-star');
                    }
                });
                self.set_value = _index;
                self.$element.find('.star').off('mouseleave');
                self.$element.find('input').val(_index);
            });
        },

        removeAllSelection: function() {
            this.$element.find('.star').each(function(){
                if ($(this).hasClass('fa-star')) {
                    $(this).removeClass('fa-star').addClass('fa-star-o');
                }
            });
        }, 

        removeSelection: function (from, to) {
            this.$element.find('.star').slice(from, to).each(function () {
                if ($(this).hasClass('fa-star')) {
                    $(this).removeClass('fa-star').addClass('fa-star-o');
                }
            })
        }
    });


    //Call the plugin instance. Main plugin function.
    $.fn.spRating = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    }

    $.fn.spRating.defaults = {
        
    }

})(jQuery, window, document);