;(function ($, window, document, undefined) {
    var name = "spGallery";
    
    function Plugin(element, options) {
        this.element = element;
        this.name = name;
        this._defaults = $.fn.spGallery.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function () {
            this.chacheElement();
            this.createHtmlDom();
        },

        //Cache element
        chacheElement: function () {
            this.$element = $(this.element);
        },

        //Set multiple attributes
        addAttributes: function (element, attributes) {
            for (let key in attributes) {
                if (attributes.hasOwnProperty(key)) {
                    element.setAttribute(key, attributes[key]);
                }
            }
            return element;
        },

        //Create necessary DOM
        createHtmlDom: function () {
            //Create spgallery-drop-area div
            let _spgallery_drop_area = this.addAttributes(document.createElement('div'), {
                class: 'spgallery-drop-area',
                id: 'spgallery-drop-area-' + this.options.galleryId
            });

            this.$element.append(_spgallery_drop_area);
            this.$spgallery_drop_area = $(_spgallery_drop_area);

            //Create spgallery-form
            let _spgallery_form = this.addAttributes(document.createElement('div'), {
                class: 'spgallery-form'
            });

            this.$spgallery_drop_area.append(_spgallery_form);
            this.$spgallery_form = $(_spgallery_form);

            //create upload-image
            let _upload_image = this.addAttributes(document.createElement('img'), {
                class: 'upload-image',
                src: this.options.uploadImgSrc
            });
            this.$spgallery_form.append(_upload_image);
            this.$upload_image = $(_upload_image);

            //create drag and drop text
            let _drag_and_drop_text = document.createElement('p');
            _drag_and_drop_text.innerHTML = this.options.ddText;
            this.$spgallery_form.append(_drag_and_drop_text);
            this.$drag_and_drop_text = $(_drag_and_drop_text);

            //create underline 
            let _underline = this.addAttributes(document.createElement('span'), {
                class: 'underline'
            });
            this.$spgallery_form.append(_underline);
            this.$underline = $(_underline);

            //create fileElem input field
            let _fileElem = this.addAttributes(document.createElement('input'), {
                class: 'fileElem',
                type: 'file', 
                id: 'fileElem_' + this.options.galleryId,
                multiple: 'multiple',
                accept: 'image/*',
                onchange: 'handleFiles(this.files)'
            });

            this.$spgallery_form.append(_fileElem);
            this.$fileElem = $(_fileElem);

            //create gallery 
            let _gallery = this.addAttributes(document.createElement('div'), {
                class: 'gallery'
            });

            this.$spgallery_drop_area.append(_gallery);
            this.$gallery = $(_gallery);

            //create input field 
            let _input_field = this.addAttributes(document.createElement('input'), {
                type: 'hidden',
                name: this.options.fieldName,
                id: this.options.galleryId,
                value: ''
            });

            this.$spgallery_drop_area.append(_input_field);
            this.$input_field = $(_input_field);

            //create upload-btn 
            let _upload_btn = this.addAttributes(document.createElement('button'), {
                class: 'btn btn-primary btn-large upload-btn'
            });
            _upload_btn.innerHTML = this.options.uploadBtnText;

            this.$spgallery_drop_area.append(_upload_btn);
            this.$upload_btn = $(_upload_btn);


        }
    });

    $.fn.spGallery = function (options) {
        this.each(function () {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    }

    $.fn.spGallery.defaults = {
        galleryId: '',
        uploadImgSrc: '',
        ddText: 'Drag and drop images or click the icon.',
        uploadBtnText: 'Upload',
        value: []
    }
})(jQuery, window, document);