jQuery(function($){
    // Pie chart
    var pie_data = Joomla.getOptions('pie_data');
    var line_data = Joomla.getOptions('line_data');
    
    
    var pie_ctx = document.getElementById('booking-earning-pie-chart').getContext('2d');
    var myPieChart = new Chart(pie_ctx, {
        type: 'doughnut',
        data: {
            labels: pie_data.labels,
            datasets: [
                {
                    backgroundColor: pie_data.colors,
                    data: pie_data.data
                }
            ]
        },
        options: {
            percentageInnerCutout: 40, 
            maintainAspectRatio: false,
            responsive: true,
            showScale: true,
            tooltips: {
                callbacks: {
                    label: function(tooltipItems, data) {
                        // return data.labels[tooltipItems.index] + ': ' + pie_data.currency + '' + data.datasets[0].data[tooltipItems.index];
                        return data.labels[tooltipItems.index] + ' ';
                    }
                }
            }
        }
    });


    // Line chart 
    var ctx = document.getElementById('booking-count-line-chart');
    var yMax = Math.max(...line_data.data);
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: line_data.labels,
            datasets: [{
                label: '# of Bookings',
                data: line_data.data,
                borderColor: "#547FFF",
                borderWidth: 3,
                fill: false
            }]
        },
        options: {
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        stepSize: 1,
                        max: yMax + 5
                    }
                }]
            }
        }
    });
});