<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Helper\ContentHelper;

class RSPageBuilderViewPages extends HtmlView
{
	public function display($tpl = null)
	{
		HTMLHelper::_('jquery.framework', true, null, true);

		Factory::getDocument()->addScriptDeclaration('var rspbld_root = "'.Uri::root().'";');
		
		RSPageBuilderHelper::loadAsset('component', 'admin-pages-import.js');
		
		$this->items			= $this->get('Items');
		$this->pagination		= $this->get('Pagination');
		$this->state			= $this->get('State');
		$this->filterForm		= $this->get('FilterForm');
		$this->activeFilters	= $this->get('ActiveFilters');
		
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}
		
		Text::script('COM_RSPAGEBUILDER_PAGES_IMPORT_SUCCESS');
		Text::script('COM_RSPAGEBUILDER_PAGES_IMPORT_FILE_TYPE_NOT_ACCEPTED');
		Text::script('COM_RSPAGEBUILDER_PAGES_IMPORT_FILE_NOT_GENERATED');
		Text::script('COM_RSPAGEBUILDER_PAGES_IMPORT_ERROR');
		
		$this->addToolBar();
		ToolbarHelper::preferences('com_rspagebuilder');
		
		parent::display($tpl);
	}
	
	protected function addToolBar() {
		$actions = ContentHelper::getActions('com_rspagebuilder');
		
		// Title
		ToolbarHelper::title(Text::_('COM_RSPAGEBUILDER'), 'rspagebuilder');
		
		// New page button
		if ($actions->get('core.create')) {
			ToolbarHelper::addNew('page.add');
		}
		
		// Edit button
		if ($actions->get('core.edit')) {
			ToolbarHelper::editList('page.edit');
		}
		
		// Publish / Unpublish button
		if ($actions->get('core.edit.state')) {
			ToolbarHelper::publish('pages.publish', 'publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('pages.unpublish', 'unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
		
		// Delete and Trush button
		if ($this->state->get('filter.published') == -2 && $actions->get('core.delete')) {
			ToolbarHelper::deleteList('', 'pages.delete', 'JTOOLBAR_EMPTY_TRASH');
		} else if ($actions->get('core.edit.state')) {
			ToolbarHelper::trash('pages.trash', 'trash', 'JTOOLBAR_TRASH', true);
		}
		
		// Export button
		ToolbarHelper::custom('pages.export', 'upload', '', Text::_('COM_RSPAGEBUILDER_EXPORT_XML'), true);
		ToolbarHelper::custom('pages.import', 'download', '', Text::_('COM_RSPAGEBUILDER_IMPORT_XML'), false);
	}

	protected function getSortFields() {
		return array(
            'p.published'	=> Text::_('JSTATUS'),
            'p.title'		=> Text::_('JGLOBAL_TITLE'),
            'access_level'	=> Text::_('JGRID_HEADING_ACCESS'),
            'author_name'	=> Text::_('JAUTHOR'),
            'language'		=> Text::_('JGRID_HEADING_LANGUAGE'),
            'p.created'		=> Text::_('JDATE'),
            'p.id'			=> Text::_('JGRID_HEADING_ID')
		);
	}
	
	public function checkForPages() {
        $db		= Factory::getDbo();
        $query	= $db->getQuery(true)
			->select('COUNT('.$db->qn('id').')')
			->from($db->qn('#__rspagebuilder'));
        $db->setQuery($query);
        
		return $db->loadResult();
	}
	
    public function getAuthors() {
        $db		= Factory::getDbo();
        $query	= $db->getQuery(true)
			->select($db->qn('u.id', 'value') . ', ' . $db->qn('u.name', 'text'))
			->from($db->qn('#__users', 'u'))
			->innerJoin( $db->qn('#__rspagebuilder', 'p') . ' ON ' . $db->qn('p.created_by') . ' = ' . $db->qn('u.id'))
			->group($db->qn('u.id'))
			->order($db->qn('u.name'));
        $db->setQuery($query);
        
        return $db->loadObjectList();
    }
}