<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Multilanguage;

$app = Factory::getApplication();

if (RSPageBuilderHelper::getClient('site')) {
	Session::checkToken('get') or die(Text::_('JINVALID_TOKEN'));
}

JLoader::register('RSPageBuilderHelperRoute', JPATH_ROOT . '/components/com_rspagebuilder/helpers/route.php');

HTMLHelper::_('behavior.core');
HTMLHelper::_('script', 'com_rspagebuilder/admin-pages-modal.js', array('version' => 'auto', 'relative' => true));
HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('behavior.multiselect');

$jversion	= RSPageBuilderHelper::getJoomlaVersion();
$user		= Factory::getUser();
$function  	= $app->input->getCmd('function', 'jSelectPage');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

if ($jversion == 3) {
	HTMLHelper::_('formbehavior.chosen', '.multipleAuthors', null, array('placeholder_text_multiple' => Text::_('JOPTION_SELECT_AUTHOR')));
	HTMLHelper::_('formbehavior.chosen', '.multipleAccessLevels', null, array('placeholder_text_multiple' => Text::_('JOPTION_SELECT_ACCESS')));
	HTMLHelper::_('formbehavior.chosen', 'select');
}

// Special case for the search field tooltip.
$searchFilterDesc = $this->filterForm->getFieldAttribute('search', 'description', null, 'filter');

if ($jversion == 3) {
	HTMLHelper::_('bootstrap.tooltip', '#filter_search', array('title' => Text::_($searchFilterDesc), 'placement' => 'bottom'));
	HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', array('placement' => 'bottom'));
}
?>

<div class="container-popup">
	<form action="<?php echo Route::_('index.php?option=com_rspagebuilder&view=pages&layout=modal&tmpl=component&function=' . $function . '&' . Session::getFormToken() . '=1');?>" method="post" name="adminForm" id="adminForm">

	<?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

	<?php
	$pages = $this->checkForPages();

	if (empty($pages)) {
	?>
		<div class="alert alert-info alert-no-items">
			<?php echo Text::_('COM_RSPAGEBUILDER_NO_PAGES_YET'); ?>
		</div>
	<?php
	} else {
		if (empty($this->items)) {
	?>
		<div class="alert alert-info alert-no-items">
			<?php echo Text::_('COM_RSPAGEBUILDER_NO_PAGES_FOUND'); ?>
		</div>
	<?php } else { ?>
		<table  class="table<?php echo ($jversion >= 4) ? ' table-sm' : ' table-striped'; ?>" id="pageList">
			<thead>
				<tr>
					<th class="<?php echo ($jversion >= 4) ? 'text-center' : 'center nowrap'; ?>" width="2%">
						<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'p.published', $listDirn, $listOrder); ?>
					</th>
					<th class="<?php echo ($jversion >= 4) ? '' : 'nowrap'; ?>">
						<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'p.title', $listDirn, $listOrder); ?>
					</th>
					<th class="<?php echo ($jversion >= 4) ? 'd-none d-md-table-cell' : 'nowrap hidden-phone'; ?>" width="10%">
						<?php echo HTMLHelper::_('searchtools.sort',  'JGRID_HEADING_ACCESS', 'p.access', $listDirn, $listOrder); ?>
					</th>
					<th class="<?php echo ($jversion >= 4) ? 'd-none d-md-table-cell' : 'nowrap hidden-phone'; ?>" width="10%">
						<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'p.language', $listDirn, $listOrder); ?>
					</th>
					<th class="<?php echo ($jversion >= 4) ? 'd-none d-md-table-cell' : 'nowrap hidden-phone'; ?>" width="10%">
						<?php echo HTMLHelper::_('searchtools.sort',  'JDATE', 'p.created', $listDirn, $listOrder); ?>
					</th>
					<th class="<?php echo ($jversion >= 4) ? 'd-none d-md-table-cell' : 'nowrap hidden-phone'; ?>" width="1%">
						<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'p.id', $listDirn, $listOrder); ?>
					</th>
				</tr>
			</thead>
			<tbody>
			<?php
			if ($jversion >= 4) {
				$iconStates = array(
					-2 => 'icon-trash',
					0  => 'icon-times',
					1  => 'icon-check',
					2  => 'icon-archive',
				);
			} else {
				$iconStates = array(
					-2 => 'icon-trash',
					0  => 'icon-unpublish',
					1  => 'icon-publish',
					2  => 'icon-archive',
				);				
			}

			foreach ($this->items as $i => $item) {
				if ($item->language && Multilanguage::isEnabled()) {
					$tag = strlen($item->language);

					if ($tag == 5) {
						$lang = substr($item->language, 0, 2);
					} else if ($tag == 6) {
						$lang = substr($item->language, 0, 3);
					} else {
						$lang = '';
					}
				} else if (!Multilanguage::isEnabled()) {
					$lang = '';
				}
	?>
				<tr class="row<?php echo $i % 2; ?>">
					<td class="<?php echo ($jversion >= 4) ? 'text-center' : 'center'; ?>">
						<?php if ($jversion >= 4) { ?>
						<span class="tbody-icon">
						<?php } ?>
						<span class="<?php echo $iconStates[$this->escape($item->published)]; ?>" aria-hidden="true"></span>
						<?php if ($jversion >= 4) { ?>
						</span>
						<?php } ?>
					</td>
					<td class="has-context">
						<?php
							$attribs = 'data-function="' . $this->escape($function) . '"'
								. ' data-id="' . $item->id . '"'
								. ' data-title="' . $this->escape($item->title) . '"'
								. ' data-url="' . $this->escape(RSPageBuilderHelperRoute::getPageRoute($item->id, $item->language)) . '"'
								. ' data-language="' . $lang . '"';
						?>
						<a class="select-link" href="javascript:void(0)" <?php echo $attribs; ?>>
							<?php echo $this->escape($item->title); ?>
						</a>
					</td>
					<td class="<?php echo ($jversion >= 4) ? 'small d-none d-md-table-cell' : 'small hidden-phone'; ?>">
						<?php echo $this->escape($item->access_level); ?>
					</td>
					<td class="<?php echo ($jversion >= 4) ? 'small d-none d-md-table-cell' : 'small hidden-phone'; ?>">
						<?php
						if ($item->language == '*') {
							echo Text::alt('JALL', 'language');
						} else {
							echo $item->language_title ? $this->escape($item->language_title) : Text::_('JUNDEFINED');
						}
						?>
					</td>
					<td class="small hidden-phone">
						<?php
						$date = $item->created;
						echo ($date > 0) ? HTMLHelper::_('date', $date, Text::_('DATE_FORMAT_LC4')) : '-';
						?>
					</td>
					<td class="<?php echo ($jversion >= 4) ? 'small d-none d-md-table-cell' : 'small hidden-phone'; ?>">
						<?php echo (int) $item->id; ?>
					</td>
				</tr>
			<?php } ?>
			</tbody>
		</table>
	<?php
		}
	}
	?>
		<div>
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo HTMLHelper::_('form.token'); ?>
		</div>
	</form>
</div>