<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;

class RSPageBuilderViewPage extends HtmlView
{
	public function display($tpl = null)
	{
		HTMLHelper::_('jquery.framework', true, null, true);

		$doc					= Factory::getDocument();
		$this->jversion			= RSPageBuilderHelper::getJoomlaVersion();
		$this->form				= $this->get('Form');
		$this->item				= $this->get('Item');
		$this->row_config		= RSPageBuilderConfig::getRowConfig();
		$this->column_config	= RSPageBuilderConfig::getColumnConfig();
		$this->elements			= RSPageBuilderConfig::getElements();
		$this->my_elements		= RSPageBuilderConfig::getMyElements();
		$this->categories		= array();
		$this->categories[]		= Text::_('COM_RSPAGEBUILDER_ALL_ELEMENTS');
		$this->google_api_key   = ComponentHelper::getParams('com_rspagebuilder')->get('google_api_key');
		
		// Set default Bootstrap version
		if (!isset($this->item->bootstrap_version)) {
			if ($this->jversion >= 4) {
				$this->item->bootstrap_version = 5;
			} else {
				$this->item->bootstrap_version = 2;
			}
		}
		
		// Modal and form validation
		if ($this->jversion == 3) {
			HTMLHelper::_('behavior.modal');
			HTMLHelper::_('behavior.formvalidation');
		}
		
		// Load Chosen files
		if ($this->jversion == 3) {
			HTMLHelper::_('formbehavior.chosen', '.element-options select');
		}
		
		// Load Bootstrap files
		if ($this->item->bootstrap_version == 2 || $this->item->bootstrap_version == 5) {
			HTMLHelper::_('bootstrap.framework');
			HTMLHelper::_('bootstrap.loadCss', true, $doc->direction);
		}
		
		// Load CSS files
		if ($this->jversion >= 4) {
			$doc->addStylesheet(Uri::root(true) . '/media/vendor/minicolors/css/jquery.minicolors.css');
		} else {
			$doc->addStylesheet(Uri::root(true) . '/media/jui/css/jquery.minicolors.css');
		}
		
		RSPageBuilderHelper::loadAsset('component', 'font-awesome.min.css');
		RSPageBuilderHelper::loadAsset('component', 'animations.css');
		RSPageBuilderHelper::loadAsset('component', 'jquery.ui.resizable.min.css');
		RSPageBuilderHelper::loadAsset('component', 'jquery.mb.YTPlayer.min.css');
		RSPageBuilderHelper::loadAsset('component', 'fields/iconslist' . ($this->jversion === 3 ? '-j3' : '') . '.css');
		RSPageBuilderHelper::loadAsset('component', 'fields/uploadimage' . ($this->jversion === 3 ? '-j3' : '') . '.css');
		RSPageBuilderHelper::loadAsset('component', 'admin-style' . ($this->jversion === 3 ? '-j3' : '') . '.css');
		
		RSPageBuilderHelper::loadGoogleFonts();
		
		$doc->addStyleSheet(HTMLHelper::_('stylesheet', 'https://unpkg.com/leaflet@1.9.3/dist/leaflet.css', array('pathOnly' => true)));
		
		// Load JS files
		if ($this->jversion >= 4) {
			$doc->addScript(Uri::root(true) . '/media/vendor/minicolors/js/jquery.minicolors.min.js');
		} else {
			$doc->addScript(Uri::root(true) . '/media/jui/js/jquery.minicolors.min.js');
		}
		$doc->addScript('https://www.youtube.com/iframe_api');
		$doc->addScript('https://player.vimeo.com/api/player.js');
		
		// Load Google Map script
        if ($this->google_api_key) {
            $doc->addScript('https://maps.google.com/maps/api/js?key=' . $this->google_api_key . '&callback=RSPageBuilderHelper.initGoogleMap', array(), array("async" => "async", "defer"=> "defer"));
        }
		
		// Load Google Map script
		$doc->addScript(HTMLHelper::script('https://unpkg.com/leaflet@1.9.3/dist/leaflet.js', array('pathOnly' => true)));

		RSPageBuilderHelper::loadAsset('component', 'beautify-html.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.ui.core.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.ui.sortable.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.ui.resizable.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.visible.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.animateNumber.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.countdownTimer.js');
		RSPageBuilderHelper::loadAsset('component', 'masonry.pkgd.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.mb.YTPlayer.min.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.videoPlayer.js');
		RSPageBuilderHelper::loadAsset('component', 'jquery.filterizr.js');
		if ($this->jversion == 3) {
			RSPageBuilderHelper::loadAsset('component', 'jquery.touchSwipe.min.js');
		}
		RSPageBuilderHelper::loadAsset('component', 'fields/iconslist.js');
		RSPageBuilderHelper::loadAsset('component', 'fields/uploadimage.js');
		RSPageBuilderHelper::loadAsset('component', 'admin-helper.js');
		RSPageBuilderHelper::loadAsset('component', 'admin-rspagebuilder.js');
		
		$doc->addScriptDeclaration('var rspbld_root = "'.Uri::root().'";');
		$doc->addScriptDeclaration('var rspbld_jversion = '.$this->jversion.';');
		
		// Get elements categories
		foreach ($this->elements as $element) {
			$this->categories[] = strtolower($element['category']);
			
			// Load each element style
			RSPageBuilderHelper::loadAsset('element', 'bootstrap' . $this->item->bootstrap_version . '/' . str_replace('rspbld_', '', $element['type']).'.css');
		}
		
		// Load template rendered elements style
        RSPageBuilderHelper::loadAsset('component', 'admin-elements-style-' . RSPageBuilderHelper::getTemplate(true) . '.css');
		
		foreach ($this->my_elements as $element) {
			$this->categories[] = strtolower($element['category']);
		}
		$this->categories = array_unique($this->categories);
		
		// Check for errors
		if (count($errors = $this->get('Errors'))) {
			throw new \Exception(implode("\n", $errors), 500);
		}
		
		// Load language
		$db		= Factory::getDbo();
		$query	= $db->getQuery(true)
			->select($db->qn('template'))
			->from($db->qn('#__template_styles'))
			->where($db->qn('client_id') . ' = ' . $db->q(0))
			->where($db->qn('home') . ' = ' . $db->q(1));
		
		$db->setQuery($query);
		$defaultemplate = $db->loadResult();
		
		$lang = Factory::getLanguage();
		$lang->load('tpl_' . $defaultemplate, JPATH_SITE, $lang->getName(), true);
		
		// Messages translations
		Text::script('COM_RSPAGEBUILDER_ERROR');
		Text::script('COM_RSPAGEBUILDER_INVALID_FIELD');
		Text::script('COM_RSPAGEBUILDER_LEAVE_PAGE');
		
		Text::script('COM_RSPAGEBUILDER_SURE_DELETE_ROW');
		Text::script('COM_RSPAGEBUILDER_SURE_REMOVE_ELEMENT');
		Text::script('COM_RSPAGEBUILDER_SURE_REMOVE_ITEM');
		Text::script('COM_RSPAGEBUILDER_REMOVE_LAST_ITEM');
		Text::script('COM_RSPAGEBUILDER_ICON_SEARCH_ICON');
		
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_TIMER_EXPIRED');
		
		Text::script('WARNING');

		// Actions translations
		Text::script('COM_RSPAGEBUILDER_ADD_ROW');
		Text::script('COM_RSPAGEBUILDER_DELETE_ROW');
		Text::script('COM_RSPAGEBUILDER_DUPLICATE_ROW');
		Text::script('COM_RSPAGEBUILDER_CONFIGURE_ROW');
		Text::script('COM_RSPAGEBUILDER_CONFIGURE_COLUMN');
		Text::script('COM_RSPAGEBUILDER_BUTTON');

		// Elements translations
		Text::script('COM_RSPAGEBUILDER_ACCORDION');
		Text::script('COM_RSPAGEBUILDER_ALERT');
		Text::script('COM_RSPAGEBUILDER_ANIMATED_NUMBER');
		Text::script('COM_RSPAGEBUILDER_BUTTON');
		Text::script('COM_RSPAGEBUILDER_CAROUSEL');
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_TIMER');
		Text::script('COM_RSPAGEBUILDER_DIVIDER');
		Text::script('COM_RSPAGEBUILDER_GOOGLE_MAP');
		Text::script('COM_RSPAGEBUILDER_HORIZONTAL_ICON_BOX');
		Text::script('COM_RSPAGEBUILDER_HORIZONTAL_IMAGE_BOX');
		Text::script('COM_RSPAGEBUILDER_ICON');
		Text::script('COM_RSPAGEBUILDER_IMAGE');
		Text::script('COM_RSPAGEBUILDER_LIST');
		Text::script('COM_RSPAGEBUILDER_MASONRY_BOXES');
		Text::script('COM_RSPAGEBUILDER_MODULE');
		Text::script('COM_RSPAGEBUILDER_OPENSTREETMAP');
		Text::script('COM_RSPAGEBUILDER_PERSONAL_BOX');
		Text::script('COM_RSPAGEBUILDER_PORTFOLIO_FILTERING');
		Text::script('COM_RSPAGEBUILDER_PRICE_BOX');
		Text::script('COM_RSPAGEBUILDER_PROGRESS_BARS');
		Text::script('COM_RSPAGEBUILDER_PROGRESS_CIRCLES');
		Text::script('COM_RSPAGEBUILDER_SPACER');
		Text::script('COM_RSPAGEBUILDER_TAB');
		Text::script('COM_RSPAGEBUILDER_TESTIMONIAL_BOX');
		Text::script('COM_RSPAGEBUILDER_TEXT_BLOCK');
		Text::script('COM_RSPAGEBUILDER_VERTICAL_ICON_BOX');
		Text::script('COM_RSPAGEBUILDER_VERTICAL_IMAGE_BOX');
		Text::script('COM_RSPAGEBUILDER_VIDEO');
		Text::script('COM_RSPAGEBUILDER_YOUTUBE_BACKGROUND_VIDEO_BOX');

		// Column fields translations
		Text::script('COM_RSPAGEBUILDER_COLUMN_MARGIN');
		Text::script('COM_RSPAGEBUILDER_COLUMN_PADDING');
		Text::script('COM_RSPAGEBUILDER_COLUMN_SUBTITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_COLUMN_SUBTITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_COLUMN_SUBTITLE_PADDING');
		Text::script('COM_RSPAGEBUILDER_COLUMN_TITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_COLUMN_TITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_COLUMN_TITLE_PADDING');

		// Row fields translations
		Text::script('COM_RSPAGEBUILDER_ROW_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ROW_PADDING');
		Text::script('COM_RSPAGEBUILDER_ROW_SUBTITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ROW_SUBTITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ROW_SUBTITLE_PADDING');
		Text::script('COM_RSPAGEBUILDER_ROW_TITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ROW_TITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ROW_TITLE_PADDING');

		// Elements fields translations
		Text::script('COM_RSPAGEBUILDER_BORDER_RADIUS');
		Text::script('COM_RSPAGEBUILDER_BORDER_WIDTH');
		Text::script('COM_RSPAGEBUILDER_BOX_MARGIN');
		Text::script('COM_RSPAGEBUILDER_BOX_PADDING');
		Text::script('COM_RSPAGEBUILDER_CLIENT_AVATAR_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_CLIENT_AVATAR_MARGIN');
		Text::script('COM_RSPAGEBUILDER_CLIENT_AVATAR_PADDING');
		Text::script('COM_RSPAGEBUILDER_CLIENT_AVATAR_WIDTH');
		Text::script('COM_RSPAGEBUILDER_CONTENT_BORDER_RADIUS');
		Text::script('COM_RSPAGEBUILDER_CONTENT_BORDER_WIDTH');
		Text::script('COM_RSPAGEBUILDER_CONTENT_MARGIN');
		Text::script('COM_RSPAGEBUILDER_CONTENT_PADDING');
		Text::script('COM_RSPAGEBUILDER_CONTROLS_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_CONTROLS_SIZE');
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_FONT_WEIGHT');
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_TEXT_COLOR');
		Text::script('COM_RSPAGEBUILDER_DETAILS_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_DETAILS_FONT_WEIGHT');
		Text::script('COM_RSPAGEBUILDER_DETAILS_TEXT_COLOR');
		Text::script('COM_RSPAGEBUILDER_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_FONT_WEIGHT');
		Text::script('COM_RSPAGEBUILDER_FORMAT');
		Text::script('COM_RSPAGEBUILDER_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_ICON_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ICON_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ICON_PADDING');
		Text::script('COM_RSPAGEBUILDER_IMAGE_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_IMAGE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_IMAGE_PADDING');
		Text::script('COM_RSPAGEBUILDER_IMAGE_WIDTH');
		Text::script('COM_RSPAGEBUILDER_INDICATORS_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_BAR_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_ITEM_BAR_WIDTH');
		Text::script('COM_RSPAGEBUILDER_ITEM_CSS_CLASS');
		Text::script('COM_RSPAGEBUILDER_ITEM_CONTENT_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ITEM_CONTENT_PADDING');
		Text::script('COM_RSPAGEBUILDER_ITEM_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_ITEM_IMAGE_HEIGHT');
		Text::script('COM_RSPAGEBUILDER_ITEM_IMAGE_WIDTH');
		Text::script('COM_RSPAGEBUILDER_ITEM_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ITEM_PADDING');
		Text::script('COM_RSPAGEBUILDER_ITEM_PERCENTAGE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_TITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_TITLE_ICON_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_ITEM_TITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_ITEM_TITLE_PADDING');
		Text::script('COM_RSPAGEBUILDER_ITEM_WIDTH');
		Text::script('COM_RSPAGEBUILDER_LONG');
		Text::script('COM_RSPAGEBUILDER_LONG_DAY');
		Text::script('COM_RSPAGEBUILDER_LONG_DAYS');
		Text::script('COM_RSPAGEBUILDER_LONG_HOURS');
		Text::script('COM_RSPAGEBUILDER_LONG_HOUR');
		Text::script('COM_RSPAGEBUILDER_LONG_MINUTE');
		Text::script('COM_RSPAGEBUILDER_LONG_MINUTES');
		Text::script('COM_RSPAGEBUILDER_LONG_SECOND');
		Text::script('COM_RSPAGEBUILDER_LONG_SECONDS');
		Text::script('COM_RSPAGEBUILDER_MARGIN');
		Text::script('COM_RSPAGEBUILDER_MARKER_TITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_NUMBER_BACKGROUND_COLOR');
		Text::script('COM_RSPAGEBUILDER_NUMBER_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_NUMBER_FONT_WEIGHT');
		Text::script('COM_RSPAGEBUILDER_NUMBER_MARGIN');
		Text::script('COM_RSPAGEBUILDER_NUMBER_PADDING');
		Text::script('COM_RSPAGEBUILDER_NUMBER_POISTION');
		Text::script('COM_RSPAGEBUILDER_NUMBER_TEXT_COLOR');
		Text::script('COM_RSPAGEBUILDER_PADDING');
		Text::script('COM_RSPAGEBUILDER_PRICE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_SHORT');
		Text::script('COM_RSPAGEBUILDER_SHORT_DAYS');
		Text::script('COM_RSPAGEBUILDER_SHORT_HOURS');
		Text::script('COM_RSPAGEBUILDER_SHORT_MINUTES');
		Text::script('COM_RSPAGEBUILDER_SHORT_SECONDS');
		Text::script('COM_RSPAGEBUILDER_SOCIAL_ICONS_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_SOCIAL_ICONS_MARGIN');
		Text::script('COM_RSPAGEBUILDER_SOCIAL_ICONS_PADDING');
		Text::script('COM_RSPAGEBUILDER_SUBTITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_SUBTITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_SUBTITLE_PADDING');
		Text::script('COM_RSPAGEBUILDER_TEXT_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_TAG_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_TAG_MARGIN');
		Text::script('COM_RSPAGEBUILDER_TAG_PADDING');
		Text::script('COM_RSPAGEBUILDER_TAGS_MARGIN');
		Text::script('COM_RSPAGEBUILDER_TAGS_PADDING');
		Text::script('COM_RSPAGEBUILDER_TITLE_FONT_SIZE');
		Text::script('COM_RSPAGEBUILDER_TITLE_MARGIN');
		Text::script('COM_RSPAGEBUILDER_TITLE_PADDING');
		Text::script('COM_RSPAGEBUILDER_URL');
		Text::script('COM_RSPAGEBUILDER_WIDTH');
		
		$this->addToolBar();
		
		parent::display($tpl);
	}

	protected function addToolBar() {
		
        // Set title
        if (Factory::getApplication()->input->getInt('id')) {
            ToolbarHelper::title(Text::sprintf('COM_RSPAGEBUILDER_EDIT_PAGE', $this->item->title), 'rspagebuilder');
        } else {
            ToolbarHelper::title(Text::_('COM_RSPAGEBUILDER_ADD_PAGE'), 'rspagebuilder');
        }
		
		// Add toolbar buttons
		ToolbarHelper::apply('page.apply');
        ToolbarHelper::save('page.save');
        ToolbarHelper::save2new('page.save2new');
        ToolbarHelper::save2copy('page.save2copy');
        ToolbarHelper::cancel('page.cancel');
	}
}