<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
?>

<form action="<?php echo Route::_('index.php?option=com_rspagebuilder&layout=edit&id='.(int)$this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">
    <?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>
    <div class="form-horizontal">
		<?php
		$fieldsets = $this->form->getFieldsets();
		
		reset($fieldsets);
		$first_tab	= key($fieldsets);
		$tab_type	= ($this->jversion >= 4) ? 'uitab' : 'bootstrap';
		
		foreach ($fieldsets as $key => $attr) {
			if ($key === $first_tab) {
				echo HTMLHelper::_($tab_type . '.startTabSet', 'page', array('active' => $attr->name));
			}
			echo HTMLHelper::_($tab_type . '.addTab', 'page', $attr->name, Text::_($attr->label, true));
		?>
		<div class="rspbld row-fluid">
			<div class="span12">
				<?php if ($this->jversion >= 4 && $this->item->bootstrap_version != 5) { ?>
				<div class="alert alert-primary alert-dismissible fade show" role="alert">
					<?php echo Text::_('COM_RSPAGEBUILDER_BOOTSTRAP_VERSION_UPDATE'); ?>
					<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
				</div>
				<?php } ?>
				
				<?php
				$fields	= $this->form->getFieldset($attr->name);
				
				foreach ($fields as $field) {
					echo $this->form->renderField($field->getAttribute('name'));
				}
				
				if ($key === $first_tab) {
					echo $this->loadTemplate('rows');
					
					// Row settings modal
					
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'modal-row-settings',
						array(
							'title'       	=> Text::_('COM_RSPAGEBUILDER_ROW_SETTINGS'),
							'backdrop'    	=> 'static',
							'keyboard'    	=> false,
							'closeButton'	=> true,
							'footer'		=> '<button class="btn btn-success" id="save-row-settings" onclick="javascript:void(0)">'.Text::_('COM_RSPAGEBUILDER_SAVE').'</button>
												<button class="btn btn-danger" id="cancel-row-settings" type="button" '.RSPageBuilderHelper::getBootstrapElement('data', 0, 'dismiss').'="modal">'.Text::_('COM_RSPAGEBUILDER_CANCEL').'</button>'
						),
						$this->loadTemplate('row_settings')
					);
					
					// Column settings modal
					
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'modal-column-settings',
						array(
							'title'       	=> Text::_('COM_RSPAGEBUILDER_COLUMN_SETTINGS'),
							'backdrop'    	=> 'static',
							'keyboard'    	=> false,
							'closeButton'	=> true,
							'footer'		=> '<button class="btn btn-success" id="save-column-settings">'.Text::_('COM_RSPAGEBUILDER_SAVE').'</button>
												<button class="btn btn-danger" id="cancel-column-settings" type="button" '.RSPageBuilderHelper::getBootstrapElement('data', 0, 'dismiss').'="modal">'.Text::_('COM_RSPAGEBUILDER_CANCEL').'</button>'
						),
						$this->loadTemplate('column_settings')
					);
					
					// Elements list modal
					
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'modal-elements-list',
						array(
							'title'       	=> Text::_('COM_RSPAGEBUILDER_ELEMENTS_LIST'),
							'backdrop'    	=> 'static',
							'keyboard'    	=> false,
							'closeButton'	=> true
						),
						$this->loadTemplate('elements_list')
					);
					
					// Element settings modal
					
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'modal-element-settings',
						array(
							'title'       	=> '',
							'backdrop'    	=> 'static',
							'keyboard'    	=> false,
							'closeButton'	=> true,
							'footer'		=> '<button class="btn btn-success" id="save-element-settings">'.Text::_('COM_RSPAGEBUILDER_SAVE').'</button>
												<button class="btn btn-danger" id="cancel-element-settings" type="button" '.RSPageBuilderHelper::getBootstrapElement('data', 0, 'dismiss').'="modal">'.Text::_('COM_RSPAGEBUILDER_CANCEL').'</button>'
						),
						$this->loadTemplate('element_settings')
					);
					
					// Element view HTML modal
					
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'modal-element-view-html',
						array(
							'title'       	=> '',
							'backdrop'    	=> 'static',
							'keyboard'    	=> false,
							'closeButton'	=> true,
							'footer'		=> '<button class="btn btn-danger" id="cancel-element-view-html" type="button" '.RSPageBuilderHelper::getBootstrapElement('data', 0, 'dismiss').'="modal">'.Text::_('COM_RSPAGEBUILDER_CLOSE').'</button>'
						),
						'<textarea onclick="this.focus();this.select()" readonly="readonly"></textarea>'
					);
					
					// Upload image modal
					
					if ($this->jversion >= 4) {
						echo HTMLHelper::_(
							'bootstrap.renderModal',
							'modal-upload-image',
							array(
								'title'       	=> Text::_('JLIB_FORM_CHANGE_IMAGE'),
								'backdrop'    	=> 'static',
								'keyboard'    	=> false,
								'closeButton'	=> true,
								'footer'		=> '<button class="btn btn-success media-save">'.Text::_('COM_RSPAGEBUILDER_SAVE').'</button>
													<button class="btn btn-danger media-close" type="button">'.Text::_('COM_RSPAGEBUILDER_CLOSE').'</button>'
							)
						);
					} else {
						echo HTMLHelper::_(
							'bootstrap.renderModal',
							'modal-upload-image',
							array(
								'title'       	=> Text::_('JLIB_FORM_CHANGE_IMAGE'),
								'backdrop'    	=> 'static',
								'keyboard'    	=> false,
								'closeButton'	=> true,
								'modalWidth'  	=> '60'
							)
						);
					}
					
					echo $this->loadTemplate('settings');
				}
				?>
			</div>
		</div>
		<?php
			echo HTMLHelper::_($tab_type . '.endTab');
		}
        ?>
    </div>
    <input type="hidden" name="task" value="page.edit" />
    <?php echo HTMLHelper::_('form.token'); ?>
</form>