<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Editor\Editor;
	
	$app			= Factory::getApplication();
	$app->getDocument()->addStyleDeclaration('.contentpane { padding: 0px; }');
	$data			= json_decode(base64_decode($app->input->get('data')));
	$editor_type	= $app->get('editor');
	$editor			= Editor::getInstance($editor_type);

	if ($editor_type === 'jce')
	{
		$data->height = '350px';
	}
	
	$editor_html = $editor->display(
		$data->name,
		'', // No need for content as we add it through JavaScript
		$data->width,
		$data->height,
		(int) $data->col,
		(int) $data->row,
		filter_var($data->buttons, FILTER_VALIDATE_BOOLEAN),
		$data->id,
		null, // $assets
		null, // $author
		[] // $params
	);
	
	// Prevent TinyMCE from using sticky toolbar
	if ($editor_type == 'tinymce') {
		$script_options = $app->getDocument()->getScriptOptions('plg_editor_tinymce');
		$script_options['tinyMCE']['default']['toolbar_sticky'] = false;
		$app->getDocument()->addScriptOptions('plg_editor_tinymce', $script_options);
	}
	
	echo '<form id="rspbld-editor-form" action="#" method="post">' . $editor_html . '</form>';
	
	$app->getDocument()->addScriptDeclaration("jQuery(document).ready(function() {
		var editor_timeout = 1000;
		
		setTimeout(function() {
			var editor			= Joomla.editors.instances['" . $data->id . "'],
				editor_iframe	= window.parent.jQuery('.rspbld-editor[data-id=\"" . $data->id . "\"]'),
				editor_value	= editor_iframe.attr('data-html'),
				clicked_element	= {},
				RSPBLD_Helper	= {};
				
			if (typeof window.parent.RSPageBuilderHelper != 'undefined') {
				RSPBLD_Helper = window.parent.RSPageBuilderHelper;
			} else if (typeof window.parent.RSPageBuilderElementsHelper != 'undefined') {
				RSPBLD_Helper = window.parent.RSPageBuilderElementsHelper;
			}
				
			editor.setValue(RSPBLD_Helper.b64Decode(editor_value));
			editor_iframe.next('.editor-loader').remove();
			
			window.parent.jQuery('#modal-element-settings .modal-body, #modal-element-settings #save-element-settings').on('click', function() {
				var editor_new_value = RSPBLD_Helper.b64Encode(editor.getValue());
				
				if (editor_value !== editor_new_value && clicked_element != jQuery(this)) { // change the element preview only if the editor value has changed
				
					editor_iframe.attr('data-html', editor_new_value);
					editor_value = editor_new_value;
					
					setTimeout(function() {
						RSPBLD_Helper.changeElement();
					}, 500);
					
					clicked_element = jQuery(this);
				}
			});
		}, editor_timeout);
	});");