<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/


// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Table\Table;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filter\OutputFilter;

class RSPageBuilderTablePage extends Table
{
	public function __construct(&$db)
	{
        parent::__construct('#__rspagebuilder', 'id', $db);
    }
	
    public function store($updateNulls = true) {
		$table	= Table::getInstance('Page', 'RSPageBuilderTable');
		$date	= Factory::getDate();
		$user	= Factory::getUser();
		$alias	= OutputFilter::stringURLSafe($this->alias);
		
		if ($this->id) {
			$this->modified		= $date->toSql();
			$this->modified_by	= $user->get('id');
		} else {
			if (!(int) $this->created) {
				$this->created = $date->toSql();
			}
			if (empty($this->created_by)) {
				$this->created_by = $user->get('id');
			}
		}
		
		if ($alias == '') {
			$alias = OutputFilter::stringURLSafe($this->title);
		}

		$this->alias = $alias;
		
		if ($table->load(array('alias' => $alias)) && ($table->id != $this->id || $this->id == 0)) {
			$this->setError(Text::_('COM_RSPAGEBUILDER_ERROR_UNIQUE_ALIAS'));
			return false;
		}

		return parent::store($updateNulls);
	}
}