<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Uri\Uri;

if (version_compare(JVERSION, '4.0', '<'))
{
	JLoader::registerAlias('Joomla\\CMS\\Form\\FormField', 'JFormField');
}

class JFormFieldRSEditor extends FormField {
	public $type = 'RSEditor';
	
	protected function getInput() {
		require_once JPATH_ADMINISTRATOR . '/components/com_rspagebuilder/helpers/rspagebuilder.php';
		
		$attributes		= $this->element;
		$data           = new \stdClass();
		
		$data->name		= $this->name;
		$data->width	= isset($attributes['data-width']) ? (string) $attributes['data-width'] : '100%';
		$data->height	= isset($attributes['data-height']) ? (string) $attributes['data-height'] : '400px';
		$data->col		= isset($attributes['data-col']) ? (string) $attributes['data-col'] : '5';
		$data->row		= isset($attributes['data-row']) ? (string) $attributes['data-row'] : '5';
		$data->buttons	= isset($attributes['data-buttons']) ? (string) $attributes['data-buttons'] : 'true';
		$data->id		= 'rseditor_' . RSPageBuilderHelper::randomNumber();
		
		$iframeHeight = (int) $data->height;
		$iframeHeight += 120;
		$iframeHeight .= 'px';
		
		$html = '<div class="rspbld-editor-container">';
		$html .= '<iframe class="rspbld-editor" width="' . $data->width . '" height="' . $iframeHeight . '" src="' . Uri::root() . 'administrator/index.php?option=com_rspagebuilder&view=editor&data=' . base64_encode(json_encode($data)) . '&tmpl=component' . '" data-name="' . $this->name . '" data-html="' . base64_encode($this->default) . '" data-id="' . $data->id . '"></iframe>';
		$html .= '<div class="editor-loader"></div>';
		$html .= '</div>';
		
		return $html;
	}
}