<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('JPATH_PLATFORM') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Factory;

FormHelper::loadFieldClass('list');

if (version_compare(JVERSION, '4.0', '<'))
{
	JLoader::registerAlias('Joomla\\CMS\\Form\\Field\\ListField', 'JFormFieldList');
}

class JFormFieldModuleslist extends ListField
{
	protected $type = 'Moduleslist';
	
	protected function getInput() {
		$html		= array();
		$attr		= !empty($this->class) ? ' class="' . $this->class . '"' : '';
		$options	= (array) $this->getModulesList();
		
		$html[] = HTMLHelper::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $this->value, $this->id);
		
		return implode($html);
	}
	
	protected function getModulesList() {
		$db     = Factory::getDbo();
		$query	= $db->getQuery(true)
			->select($db->qn('id') . ', ' . $db->qn('title'))
			->from($db->qn('#__modules'))
			->where($db->qn('client_id'). ' = 0')
			->where($db->qn('published') . ' = 1')
			->order($db->qn('ordering') . ', ' . $db->qn('title'));
		$db->setQuery($query);
		$modules = $db->loadObjectList();
		
		foreach ($modules as $module) {
			$tmp = array(
					'value'    => $module->id,
					'text'     => $module->title
				);
			
			$options[] = (object) $tmp;
		}
		
		reset($options);
		
		return $options;
	}
}